#version 330

#if ARRAY_TEXTURES
uniform sampler2DArray Tex0;
#else
uniform sampler2D Tex0;
#endif

in vec3 uv;
in vec4 vcolor;

out vec4 oColor;

void main()
{
	vec2 dx = dFdx(uv.xy);
	vec2 dy = dFdy(uv.xy);
#if ARRAY_TEXTURES
	vec4 texColor = textureGrad(Tex0, uv.xyz, dx, dy);
#else
	vec4 texColor = textureGrad(Tex0, uv.xy, dx, dy);
#endif
	oColor = vec4(mix(vcolor.rgb, texColor.rgb, texColor.a), 1.0);
}
